up:: [[LYT Kit]]
tags:: #output/article☑️ 
URL:: [Medium](https://medium.com/@nickmilo22/in-what-ways-can-we-form-useful-relationships-between-notes-9b9ec46973c6)

> [!NOTE] This is the 2nd best version. The best version is in the LYT Curriculum.
> 

# In what ways can we form useful relationships between notes?
Are you into personal knowledge management (PKM)? Are you confused about when to use a **folder** versus a **tag** versus a **link** versus a **Map of Content**? Let’s explore each “relationship-builder” and how we can use them expertly.

_Main Ideas_

*   Top-down categorizing has gotten a bad rap. It has a place.
*   Bottom-up creating is great, but it needs a bit of top-down structure as your library grows. But using just folders is the WRONG way.
*   **Maps of Contents (MOCs)** are game-changers.

A flat structure of notes — i.e. one big folder — is “frictionless”. There is no thinking “now where exactly does this go?” However, over time it becomes messy and overwhelming. To overcome the chaos, we need to build healthy, flexible frameworks that can grow with our knowledge over time.

Let’s examine the known— and lesser known — ways we form useful relationships between notes.

### Direct Links
![Image for post](https://miro.medium.com/max/1408/1*SMU0M-iBKedBR6PwUKrayw.png)

Direct links are the strongest type of relationship. They are the purest and most explicit way of connecting two notes. This is the core method of growing a healthy, dynamic zettelkasten.

Despite the proclamations, direct links alone are not enough. They do not allow for easy, dependable high-level navigation. They are a system of streets connecting one block to another. But sometimes you want to zoom out and view the map.

### Folders
Folders are rigid and exclusionary by their nature. Whatever is in a folder lives separated from the main collection. It’s a rigid hierarchy that imposes order. Without special workarounds this limits note accessibility, discourages interdisciplinary thinking, and stunts the long-term growth of a complex and interesting Zettelkasten.

There are some strategic uses for folders, but their overuse may be a sign that the user is uncomfortable with other, arguably better methods of building relationships between notes while maintaining the long-term health of their digital library. If you have some quixotic notion about creating a digital library that acts as an interesting conversation partner — folders don’t make it as easy.

What about for projects? Depending on the use cases, a person might like using folders for projects.

*   If your goal is to manage projects, folders are great — maybe even ideal. You might decide that you want your projects to be actively walled-off units.
*   But once they are final, you would need to take the extra steps of reformulating any good stuff into your main digital library.

A possible use for a folder is as a temporary inbox, or “incubation” folder. As long as you view these research streams as temporary staging grounds, to be deleted or assimilated with the Borg- er, I mean, your main-brain-frame; you should be fine. Otherwise, that inbox folder can get awfully crufty.

Another possible use for folders would be for “very clearly defined” notes. For example, things like: Images, People, Quotes, and Source Materials (things written by other people). You don’t have to use these folders; you could easily add their contents into the main vault; but you might find it keeps things slightly more tidy.

But know this: retreating too much into project-based folder management will cripple your long-term thinking partner (i.e., your zettelkasten) from growing complex, dynamic, and interesting cross-genre connections. You won’t have a zettelkasten, you’ll have a collection of silo-ed folders. Those are massive costs to consider.

That said, limiting accessibility may be ideal for private information like finances, health, and private journaling. Then a folder is the perfect instrumental to intentionally cordon off those notes from the rest.

### Tags
Tags are relatively weak associations, but don’t discount them. They are easy ways to quickly filter large swathes of notes. Tags are more fluid: one note can have multiple tags. The problem is that _tags alone don’t scale_.

Say you have a `#PermanentNote` tag or tag page. Whenever you take notes on something you read or watch, you apply that tag. It’s great when only 50 notes have that tag. It’s far less useful when 500 notes have that tag.

#### Multiple Tags
A partial solution is to use multiple tags, so you can search for: `#PermanentNote` `#habit` to filter in only those results.

> But the problem here is that you have to remember each tag!

What happens when you can’t remember that when you’re tagging a new note? You end up using `#improvement` or something else. Sure, maybe you can remember this single `#habit` example. But over time you’ll lose track of how to tag a new note in a way you can reliably retrieve (meaning that it will scale well and you’ll remember it). By the way, software that allows for “starred” notes is just exercising a form of tagging.

#### Tags with Saved Boolean Search
Saved Searches are another partial and robust solution. You can save a tag search like `#PermanentNote` AND `#habit`.

![Image for post](https://miro.medium.com/max/764/1*uCSHtOqZCE3izP1-l_6RUQ.png)

#### Using Tags for Chronological Searches
Tags also work well in the temporal context. Here are some tags that work well as a search when your notes have timestamps:  `#journal | #writing ; #people | #waiting | #log/meeting ; #health | #workout ; and even #source`

### Proximity
Everyone tends to forget how we use the proximity between notes to build relationships. Organizing by proximity can be weak and arbitrary (airplane flight sitting next to total strangers) or strong and meaningful (airplane flight next to your family). It just depends on what level you apply it. There are 3 basic levels of proximity.

1.  **Organizing by Proximity in the main folder:**

*   _Alphabetical_: Sure “Apple” and “Banana” start next to each other and hold a strong relationship. But over time that proximity will change; because years later the list looks like “Apple”, “aqua”, “aqualung”, “arabesque”, “arachne”, “arbiter”, “arc”, “arena”, “aries”, “arise”, “Arkansas”, “Banana”. So relationships that start out strong can weaken over time.

![Image for post](https://miro.medium.com/max/586/1*uzcKVhnrPyQ6bNNwEuCP6Q.png)

*   _Chronological:_ If you sort by creation date, the proximities between notes won’t change but they are inherently more arbitrary (random), except for their temporal context (which holds varying value depending on the context).

**2\. Organizing by Proximity in the same subfolder:**

*   Notes in the same subfolder will have a closer relationship since they are grouped in the same vicinity. But this comes at the cost of being silo-ed from the rest of the note library.

**3\. Organizing by Proximity in an MOC (Map of Content):**

![Image for post](https://miro.medium.com/max/930/1*_2jKjcURnsgnTmDCZWspuA.png)

*   Notes in the same MOC are very likely to be closely related, especially after they are manually sorted in some form of relational positioning. This is the best way to apply the power of proximity.

Using just a single note, you can identify and build relationships between notes.

### Map of Contents (MOC)
![Image for post](https://miro.medium.com/max/2856/1*-zaTKc2p6Bv_lGR7DCwHmQ.png)

An MOC is just a note — a very special type of note. It uses proximity effectively and acts like a tag and a non-exclusive folder at the same time.

*   Tag-like: It groups the links of associated notes in a non-exclusive way. (The notes themselves live freely elsewhere.)
*   Folder-like: It assembles notes in a tightly-packed grouping.
*   Proximity: It grants you the ability to deliberately position each note in relation to the other notes.

> In this way, MOCs don’t limit access, they **curate** it — while keeping your notes free.

Using MOCs is like being in your own warehouse full of workbenches, where each workbench contains a selection of highly curated index cards for you to engage with.

Another way to consider MOCs is through emergence.

> MOCs are Evergreen notes, just at the next level of emergence.

In an MOC, the party is always happening. It’s the “room where it happens.” Individual notes can “shadow-clone” themselves and essentially be in multiple parties simultaneous — interacting and developing complexity from each party at the same time!

_Q: How do MOCs compare to TOCs (Table of Contents)?_

A: Whereas MOCs are fluid, TOCs are rigid. This is by design. A table of contents is for assembling a specific and linear order. MOCs serve much broader purposes. Oftentimes an MOC can morph into a TOC as a project starts to finalize.

### A Home Note
![Image for post](https://miro.medium.com/max/2418/1*XDjhBzNev_j-6EnXRFoc3Q.png)

Think of your Home note as the highest-level of your zettelkasten / digital library. It has links to the main MOCs in your library along with your most relevant tags.

It is an excellent access point because it encourages you to focus on the areas in your life that you’ve deemed as important.

A Home note creates stronger, longer-lasting connections, especially as one’s library grows far beyond 1000 notes.

### Don’t fall for the dogma
Until recently, folders were all we had. They weren’t good enough. Now we have links. Now many people have taken a hard stance that all they need are links. Hard stances become fragile stances. Don’t fall for the dogma. The right tools for a healthy digital library include a multitude of relationship-builders.

These relationship-builders include: a Home note. Maps of Content. Direct Links. Proximity. Tags.

And yes, even a few folders.

---

- Back Matter
	- dates:: 2020-08-08
	- published:: 2020-08-08

---